package gov.va.vinci.dart.dms.db.mock;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

import gov.va.vinci.dart.dms.biz.Content;
import gov.va.vinci.dart.dms.biz.Document;
import gov.va.vinci.dart.dms.biz.Label;
import gov.va.vinci.dart.dms.db.ContentDAO;

public class ContentDAOMock implements ContentDAO {
	private static HashMap<Integer,Content> IDHash = new HashMap<Integer,Content>();
	private static boolean initialized = false;
	private static int idCounter = 1;

	@Override
	public void save(Content content) {
		if (content == null) {
			throw new IllegalArgumentException();
		}
		
		initializeContentHash();
		
		if (content.getId() == 0) {
			content.setId(idCounter++);
		}
		
		IDHash.put(content.getId(), content);
	}


	@Override
	public Content findById(int contentId) {
		initializeContentHash();
		
		return IDHash.get(contentId);
	}

	@Override
	public List<Content> listByRepository(int repositoryId) {
		initializeContentHash();
		
		List<Content> result = new ArrayList<Content>();
		
		for (Integer id: IDHash.keySet()) {
			Content cnt = IDHash.get(id);
			if (cnt.getRepository().getId() == repositoryId) {
				result.add(cnt);
			}
		}
			
		return result;
	}

	private void initializeContentHash() {
		if (initialized == true) {
			return;
		}
		initialized = true;
	}

}
